<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once("common_methods.php");
class booking extends Common_methods 
{
	function __construct()
	{	
		$this->login_type	='';
		$this->layout		='default';
		$this->access      ='';
		parent::__construct();
		$this->_init();
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
		$this->load->helper('text');
		$this->load->model("cars_model");
		$this->load->model("pricing_model");		
		$this->load->model("car_facilities_detail_model");
		$this->load->model("car_pickup_location_detail_model");
		$this->load->model("bookings_model");
		$this->load->model("locations_model");
		$this->load->model("characteristics_groups_model");
		$this->load->model("characteristics_model");
		$this->load->model("high_period_notification_model");
		$this->load->model("insurance_group_items_model");
		$this->load->model("insurance_group_model");
		$this->load->model("insurance_detail_model");
		$this->load->model("category_insurance_price_model");
		$this->load->model("minimum_rental_days_model");
		$this->load->model("stop_sale_period_model");
		$this->load->model("countries_model");

	}

	public function index($id)
	{	
		$this->load->css("plugins/icheck/skins/line/red.css");	
		$pickup_location = ($this->input->post('pickup_location') > 0) ? $this->input->post('pickup_location') : 0;
		$dropoff_location = ($this->input->post('dropoff_location') > 0) ? $this->input->post('dropoff_location') : 0;
		$pickup_date = ($this->input->post('pickup_date') != "") ? $this->input->post('pickup_date') : "";
		$dropoff_date = ($this->input->post('dropoff_date') != "") ? $this->input->post('dropoff_date') : "";
		$pickup_time = ($this->input->post('pickup_time') != "") ? $this->input->post('pickup_time') : "";
		$dropoff_time = ($this->input->post('dropoff_time') != "") ? $this->input->post('dropoff_time') : "";
		$type = ($this->input->post('type') != "") ? $this->input->post('type') : "";
		$offer_id = ($this->input->post('offer_id') != "") ? $this->input->post('offer_id') : "";
		
		$facilities = ($this->input->post('car_facilities') != "") ? $this->input->post('car_facilities') : "";
		
		$insuranceGroupId = ($this->input->post('insuranceGroupId') > 0) ? $this->input->post('insuranceGroupId') : "";

		$car_data = $this->cars_model->get($id);	
		
		$booking_days =  date_difference($pickup_date,$dropoff_date);

		if($id > 0 && $pickup_location > 0 && $dropoff_location > 0 && $pickup_time != "" && $dropoff_time != "" && $pickup_date != "" && $dropoff_date != "" && !empty($car_data))
		{

			/*Check for booking lies in upcoming two months*/
			/*$booking_max_date = date('Y-m-d', strtotime('+2 months'));
			$booking_max_date_timespan = strtotime($booking_max_date);
			$bookingdate_timespan = strtotime($pickup_date);*/
			$this->data["booking_msg"] = "";
			$two_month_status = $this->booking_check_maximum_two_month($pickup_date);
			if($two_month_status === false)
			{
				$this->data["booking_msg"] = lang("MAXIMUM_TWO_MONTH_BOOKING_ALLOWED");
				$this->data["booking_msg_classnm"] = "error";
				$this->data["booking_btn_disabled"] = true;
			}
			/*Check for booking lies in upcoming two months*/

			/*Check for stop sale period change*/
			$where_ar[] = array("(('".$pickup_date."' BETWEEN start_date AND end_date) OR ('".$dropoff_date."' BETWEEN start_date AND end_date)) AND locationId = '".$pickup_location."' AND categoryId = '".$car_data['categoryId']."'",null,false);
			$stop_sale_records = $this->stop_sale_period_model->set_fields("categoryId")->get_many_by($where_ar);
			if(!empty($stop_sale_records))
			{
				$this->data["booking_msg"] = lang("STOP_SALE_PERIOD_NOW");
				$this->data["booking_msg_classnm"] = "error";
				$this->data["booking_btn_disabled"] = true;
			}
			/*Check for stop sale period change*/

			/*check for minimum rental days check*/

			$where_ar_rental_days[] = array("(('".$pickup_date."' BETWEEN start_date AND end_date) OR ('".$dropoff_date."' BETWEEN start_date AND end_date)) AND locationId = '".$pickup_location."' AND days > '".$booking_days."'",null,false);
			$minimum_rental_records = $this->minimum_rental_days_model->get_many_by($where_ar_rental_days);
			if(!empty($minimum_rental_records))
			{
				$this->data["booking_msg"] = lang("PLEASE_SELECT_MINIMUM_RENTAL_DAYS");
				$this->data["booking_msg_classnm"] = "error";
				$this->data["booking_btn_disabled"] = true;
			}
			/*check for minimum rental days check*/
			$this->load->start_inline_scripting();
			echo "Appfd.initBookingOperation();";
			echo "Appfd.initCarSearchFormCommon();";			
			$this->load->end_inline_scripting(false,false);
			$this->data["pickup_location"] = $pickup_location;
			$this->data["dropoff_location"] = $dropoff_location;

			$pickup_location_ar = $this->locations_model->get($pickup_location);
			$dropoff_location_ar = $this->locations_model->get($dropoff_location);

			$this->data["pickup_location_nm"] = $pickup_location_ar["location_name"];
			$this->data["dropoff_location_nm"] = $dropoff_location_ar["location_name"];

			$this->data["pickup_date"] = $pickup_date;
			$this->data["dropoff_date"] = $dropoff_date;
			$this->data["pickup_time"] = $pickup_time;
			$this->data["dropoff_time"] = $dropoff_time;
			$this->data["car_data"] = $car_data;

			/*printr($this->data["car_data"]);*/
			$this->pricing_model->car_category = $car_data["categoryId"];
			$this->pricing_model->pickup_date = $pickup_date;
			$this->pricing_model->pickup_time = $pickup_time;
			$this->pricing_model->dropoff_date = $dropoff_date;
			$this->pricing_model->dropoff_time = $dropoff_time;
			$this->pricing_model->car_id = $car_data["id"];
			$this->pricing_model->booking_selected_facilities = $facilities;
			$this->pricing_model->insuranceGroupId = $insuranceGroupId;

			$price_ar = $this->pricing_model->get_car_price();
			if(!empty($price_ar))
			{
				$this->data["booking_pricing"]["original_price"] = $price_ar["original_price"];
				$this->data["booking_pricing"]["advanced_price"] = $price_ar["advanced_price"];
				$this->data["booking_pricing"]["basic_price"] = $price_ar["basic_price"];
				$this->data["booking_pricing"]["dropoff_price"] = $price_ar["dropoff_price"];
				$this->data["booking_pricing"]["per_day_price"] = $price_ar["per_day_price"];
				$this->data["booking_pricing"]["total"] = $price_ar["total"];
				$this->data["booking_pricing"]["special_offer_price"] = $price_ar["special_offer_price"];
				$this->data["booking_pricing"]["coupon_applied_price"] = $price_ar["coupon_applied_price"];
				$this->data["booking_pricing"]["booking_total_days"] = $price_ar["booking_total_days"];
				$this->data["booking_pricing"]["driver_age_price"] = $price_ar["driver_age_price"];
				$this->data["booking_pricing"]["from_time_surcharge_price"] = isset($price_ar["from_time_surcharge_price"]) ? $price_ar["from_time_surcharge_price"] : 0;
				$this->data["booking_pricing"]["to_time_surcharge_price"] = isset($price_ar["to_time_surcharge_price"]) ? $price_ar["to_time_surcharge_price"] : 0;
				$this->data["booking_pricing"]["insurance_price"] = isset($price_ar["insurance_price"]) ? $price_ar["insurance_price"] : 0;				
			}
			
			$this->data["pickup_location_time"] = $this->get_opening_time_from_location($pickup_location);
			$this->data["dropoff_location_time"] = $this->get_opening_time_from_location($dropoff_location);
			/*insurance_group_items*/
			
			/*category_insurance_price*/
			if($this->isAjax)
			{
				$this->view = false;
				$this->layout = false;
				$this->json = true;
				/*printr($this->data["booking_pricing"]);*/

			}
			else{

				$this->data["locations"] = $this->locations_model->set_fields("id,location_name")->get_many_by("status",'y');

				$this->data["countries"] = $this->countries_model->set_fields("id,country_name")->get_many_by("status",'y');

				$insurance_group_items = $this->insurance_group_items_model->get_all();
				if(!empty($insurance_group_items))
				{

					$data_insurance_group_items = array();
					$data_insurance_group_items[0]["id"] = 0;
					$data_insurance_group_items[0]["name"] = 'Deposit';
					$tempkey = 1;
					foreach ($insurance_group_items as $key => $value) {
						$data_insurance_group_items[] = $value;
						$tempkey++;
					}
					$data_insurance_group_items[$tempkey]["id"] = $tempkey + 1;
					$data_insurance_group_items[$tempkey]["name"] = 'Price';
					$this->data["data_insurance_group_items"] = $data_insurance_group_items;			
				}
				/*insurance_group_items*/

				/*Get insurance groups*/

				$insurance_groups = $this->insurance_group_model->get_all();
				if(!empty($insurance_groups))
				{


					$data_insurance_group = array();
					$tempkey = 1;
					foreach ($insurance_groups as $key => $group) 
					{
						$where_ar = array('groupId'=>$group["id"],'categoryId'=>$car_data["categoryId"]);
						$var_ar = $this->category_insurance_price_model->set_fields("price,deposit,max_price")->get_by($where_ar);
						$temp1[0]["name"] = 'Deposit';
						$temp1[0]['text'] = $var_ar["deposit"];
						$temp1[0]['type'] = "text";
						$temp1[0]['check'] = false;
						if(!empty($insurance_group_items))
						{
							foreach ($insurance_group_items as $key => $value_n) {
								$exist_check_where = array('groupId'=>$group["id"],'itemId'=>$value_n["id"]);
								$exist_check = $this->insurance_detail_model->get_by($exist_check_where);
								$response[$value_n["id"]] = (!empty($exist_check)) ? true  : false;
							}
						}
						$temp2 = $response;
						$k = $temp1+$temp2;
						$total_insurance_price = $var_ar["price"] * $booking_days;
						if($total_insurance_price > $var_ar["max_price"])
						{
							$total_insurance_price = $var_ar["max_price"];
						}
						$temp_k['name'] = 'Price';
						$temp_k['text'] = $total_insurance_price;
						$temp_k['type'] = "text";
						$temp_k['check'] = false;
						array_push($k,$temp_k);
						$group["items"] = $k;
						$data_insurance_group[] = $group;
					}
				}
				$this->data["data_insurance_group"] = $data_insurance_group;
				$this->output->set_title(lang("Book a car".$car_data["name"]));	
			}
			$this->data["price_view_render"] = $this->load->view("booking/price_detail",$this->data,true);
		}
		else{
			$this->session->set_flashdata("error",lang(""));
			redirect(base_url()."fleetguide","refresh");
		}
	}

	public function booking_check_maximum_two_month($pickup_date)
	{	
		/*Check for booking lies in upcoming two months*/
		$booking_max_date = date('Y-m-d', strtotime('+2 months'));
		$booking_max_date_timespan = strtotime($booking_max_date);
		$bookingdate_timespan = strtotime($pickup_date);
		if($booking_max_date_timespan < $bookingdate_timespan)
		{
			return false;
		}
		/*Check for booking lies in upcoming two months*/
		return true;
	}


	public function booking_confirm()
	{

	}


	public function booking_operations(){
		if($this->isAjax)
		{
			$this->view = false;
			$this->json = true;
			$this->layout = false;

			$insurance_id = $this->input->post("");
			$insurance_id = $this->input->post("");


		}
		else{
			redirect(base_url(),"refresh");	
		}
	}

}
